#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int size = 100 * 1000;

vector <pair <int, int> > vertex[size];

int n, m;
int v[size];
int u[size];
bool inspan[size];
vector <int> span;
bool used[size];
bool bridge[size];
int up[size];
int deep[size];

void findspan(int v) {
	used[v] = true;
	for (int i = 0; i < (int) vertex[v].size(); i++)
		if (!used[vertex[v][i].fs]) {
			span.pb(vertex[v][i].sc);
			inspan[vertex[v][i].sc] = true;
			findspan(vertex[v][i].fs);
		}
}

int dfs(int v, int fr, int d) {
	used[v] = true;
	deep[v] = d;
	up[v] = d;
	int cnt = 1;

	for (int i = 0; i < (int) vertex[v].size(); i++) {
		if (vertex[v][i].sc != fr) {
			if (used[vertex[v][i].fs])
				up[v] = min(up[v], up[vertex[v][i].fs]);
			else {
				cnt += dfs(vertex[v][i].fs, vertex[v][i].sc, d + 1);
				up[v] = min(up[v], up[vertex[v][i].fs]);
				bridge[vertex[v][i].sc] = deep[v] < up[vertex[v][i].fs];
			}
		}
	}

	return cnt;
}

int main() {
	//assert(freopen("input.txt", "r", stdin));
	//assert(freopen("output.txt", "w", stdout));

	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; i++) {
		scanf("%d%d", &v[i], &u[i]);
		v[i]--, u[i]--;

		vertex[v[i]].pb(mp(u[i], i));
		vertex[u[i]].pb(mp(v[i], i));
	}

	findspan(0);

	int ans = 0;
	for (int i = 0; i < m; i++) {
		if (inspan[i]) {
			for (int j = 0; j < (int) vertex[v[i]].size(); j++) {
				if (vertex[v[i]][j].sc == i) {
					swap(vertex[v[i]][j], vertex[v[i]].back());
					vertex[v[i]].pop_back();
					break;
				}
			}
			for (int j = 0; j < (int) vertex[u[i]].size(); j++) {
				if (vertex[u[i]][j].sc == i) {
					swap(vertex[u[i]][j], vertex[u[i]].back());
					vertex[u[i]].pop_back();
				}
			}

			for (int j = 0; j < m; j++) {
				bridge[j] = false;
				used[j] = false;
			}
			if (dfs(0, -1, 0) != n) {
				for (int j = 0; j < m; j++)
					if (j != i && (!inspan[j] || j > i))
						ans++;
			} else {
				for (int j = 0; j < m; j++)
					if (j != i && bridge[j] && (!inspan[j] || j > i))
						ans++;
			}

			vertex[v[i]].pb(mp(u[i], i));
			vertex[u[i]].pb(mp(v[i], i));
		}
	}

	cout << ans << endl;

	return 0;
}